/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import club.sk1er.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class AbstractCompoundRule
extends Rule {
    static final int MAX_TERMS = 5;
    private final String withHyphenMessage;
    private final String withoutHyphenMessage;
    private final String withOrWithoutHyphenMessage;
    private final String shortDesc;
    protected boolean sentenceStartsWithUpperCase = false;

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    @Override
    public int estimateContextForSureMatch() {
        return 1;
    }

    protected abstract CompoundRuleData getCompoundRuleData();

    public AbstractCompoundRule(ResourceBundle messages, String withHyphenMessage, String withoutHyphenMessage, String withOrWithoutHyphenMessage) throws IOException {
        this(messages, withHyphenMessage, withoutHyphenMessage, withOrWithoutHyphenMessage, null);
    }

    public AbstractCompoundRule(ResourceBundle messages, String withHyphenMessage, String withoutHyphenMessage, String withOrWithoutHyphenMessage, String shortMessage) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.withHyphenMessage = withHyphenMessage;
        this.withoutHyphenMessage = withoutHyphenMessage;
        this.withOrWithoutHyphenMessage = withOrWithoutHyphenMessage;
        this.shortDesc = shortMessage;
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    public boolean isHyphenIgnored() {
        return true;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        RuleMatch prevRuleMatch = null;
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(5);
        for (int i = 0; i < tokens.length + 5 - 1; ++i) {
            AnalyzedTokenReadings token = i >= tokens.length ? new AnalyzedTokenReadings(new AnalyzedToken("", "", null), ((AnalyzedTokenReadings)prevTokens.peek()).getStartPos()) : tokens[i];
            if (i == 0) {
                this.addToQueue(token, prevTokens);
                continue;
            }
            if (token.isImmunized()) continue;
            AnalyzedTokenReadings firstMatchToken = (AnalyzedTokenReadings)prevTokens.peek();
            ArrayList<String> stringsToCheck = new ArrayList<String>();
            ArrayList<String> origStringsToCheck = new ArrayList<String>();
            Map<String, AnalyzedTokenReadings> stringToToken = this.getStringToTokenMap(prevTokens, stringsToCheck, origStringsToCheck);
            for (int k = stringsToCheck.size() - 1; k >= 0; --k) {
                String[] parts;
                String stringToCheck = (String)stringsToCheck.get(k);
                String origStringToCheck = (String)origStringsToCheck.get(k);
                if (!this.getCompoundRuleData().getIncorrectCompounds().contains(stringToCheck)) continue;
                AnalyzedTokenReadings atr = stringToToken.get(stringToCheck);
                String msg = null;
                ArrayList<String> replacement = new ArrayList<String>();
                if (!this.getCompoundRuleData().getNoDashSuggestion().contains(stringToCheck)) {
                    replacement.add(origStringToCheck.replace(' ', '-'));
                    msg = this.withHyphenMessage;
                }
                if (this.isNotAllUppercase(origStringToCheck) && !this.getCompoundRuleData().getOnlyDashSuggestion().contains(stringToCheck)) {
                    replacement.add(this.mergeCompound(origStringToCheck, this.getCompoundRuleData().getNoDashLowerCaseSuggestion().stream().anyMatch(s -> origStringsToCheck.contains(s))));
                    msg = this.withoutHyphenMessage;
                }
                if ((parts = stringToCheck.split(" ")).length > 0 && parts[0].length() == 1) {
                    replacement.clear();
                    replacement.add(origStringToCheck.replace(' ', '-'));
                    msg = this.withHyphenMessage;
                } else if (replacement.isEmpty() || replacement.size() == 2) {
                    msg = this.withOrWithoutHyphenMessage;
                }
                RuleMatch ruleMatch = new RuleMatch(this, sentence, firstMatchToken.getStartPos(), atr.getEndPos(), msg, this.shortDesc);
                ruleMatch.setSuggestedReplacements(replacement);
                if (prevRuleMatch != null && prevRuleMatch.getFromPos() == ruleMatch.getFromPos()) {
                    prevRuleMatch = ruleMatch;
                    break;
                }
                prevRuleMatch = ruleMatch;
                ruleMatches.add(ruleMatch);
                break;
            }
            this.addToQueue(token, prevTokens);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private Map<String, AnalyzedTokenReadings> getStringToTokenMap(Queue<AnalyzedTokenReadings> prevTokens, List<String> stringsToCheck, List<String> origStringsToCheck) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, AnalyzedTokenReadings> stringToToken = new HashMap<String, AnalyzedTokenReadings>();
        int j = 0;
        boolean isFirstSentStart = false;
        for (AnalyzedTokenReadings atr : prevTokens) {
            sb.append(' ');
            sb.append(atr.getToken());
            if (j == 0) {
                isFirstSentStart = atr.hasPosTag("SENT_START");
            }
            if (j >= 1) {
                String stringToCheck = this.normalize(sb.toString());
                if (this.sentenceStartsWithUpperCase && isFirstSentStart) {
                    stringToCheck = StringUtils.uncapitalize(stringToCheck);
                }
                stringsToCheck.add(stringToCheck);
                origStringsToCheck.add(sb.toString().trim());
                if (!stringToToken.containsKey(stringToCheck)) {
                    stringToToken.put(stringToCheck, atr);
                }
            }
            ++j;
        }
        return stringToToken;
    }

    private String normalize(String inStr) {
        String str = inStr.trim();
        if (str.indexOf(45) != -1 && str.indexOf(32) != -1) {
            str = this.isHyphenIgnored() ? str.replace('-', ' ') : str.replace(" - ", " ");
        }
        return str;
    }

    private boolean isNotAllUppercase(String str) {
        String[] parts;
        for (String part : parts = str.split(" ")) {
            if (!this.isHyphenIgnored() && "-".equals(part) || !StringTools.isAllUppercase(part)) continue;
            return false;
        }
        return true;
    }

    private String mergeCompound(String str, boolean uncapitalizeMidWords) {
        String[] stringParts = str.split(" ");
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < stringParts.length; ++k) {
            if (!this.isHyphenIgnored() && "-".equals(stringParts[k])) continue;
            if (k == 0) {
                sb.append(stringParts[0]);
                continue;
            }
            sb.append(uncapitalizeMidWords ? StringUtils.uncapitalize(stringParts[k]) : stringParts[k]);
        }
        return sb.toString();
    }

    private void addToQueue(AnalyzedTokenReadings token, Queue<AnalyzedTokenReadings> prevTokens) {
        boolean inserted = prevTokens.offer(token);
        if (!inserted) {
            prevTokens.poll();
            prevTokens.offer(token);
        }
    }
}

